<?php
	function get_xth_workday($xday, $month, $year)
	{
		$es = easter_date($year);
		$sd = 24 * 60 * 60;
		$days = 0;
		$month;
		$year;
		$workdays = 0;
		$is_holiday = false;
		$holidays = array
		(
			//$es - (48 * $sd),					//Rosenmontag
			//$es - (47 * $sd),					//Faschingsdienstag
			//$es - (46 * $sd),					//Aschermittwoch
			//$es - (7 * $sd),						//Palmsonntag
			$es - (2 * $sd),				//Karfreitag
			$es,							//Ostersonntag
			$es + (1 * $sd),				//Ostermontag
			//$es + (7 * $sd),						//low_sunday => keine deutsche Entsprechung gefunden
			$es + (39 * $sd),				//Christi Himmelfahrt
			$es + (49 * $sd),				//Pfingstsonntag
			$es + (50 * $sd),				//Pfingstmontag
			$es + (60 * $sd),				//Fronleichnam
			mktime(0, 0, 0, 1, 1, $year),	//Neujahr
			mktime(0, 0, 0, 5, 1, $year),	//Maifeiertag
			mktime(0, 0, 0, 10, 3, $year),	//Tag der Deutschen Einheit
			mktime(0, 0, 0, 12, 25, $year),	//1. Weihnachtsfeiertag
			mktime(0, 0, 0, 12, 26, $year)	//2. Weihnachtsfeiertag
		);
		while($workdays < $xday)
		{
			$days ++;
			$dayofweek = date("w", mktime(0, 0, 0, $month, $days, $year));
			if($dayofweek != 0 && $dayofweek != 6)
			{
				for($i = 0; $i < count($holidays); $i++)
				{
					if($holidays[$i] == mktime(0, 0, 0, $month, $days, $year))
					{
						$is_holiday = true;
					}
				}
				if(! $is_holiday)
				{
					$workdays++;
				}
				$is_holiday = false;
			}
		}
		return date("U", mktime(0, 0, 0, $month, $days, $year));
	}
// #######################################################################################
	function get_next_update_month($xday)
	{
		$act_month = date("m");
		$act_year = date("Y");
		$act_date = date("U");
		if($act_date >= get_xth_workday($xday, $act_month, $act_year))
		{
			$act_month++;
		}
		if($act_month > 12)
		{
			$act_month--;
			$act_year++;
		}
		return array('month' => $act_month, 'year' => $act_year);
	}
// #######################################################################################
	function get_longest_line($filename)
	{
		$byte_counter = 0;
		$max = 0;
		$fr = fopen ($filename, "r");
		$str = fread ($fr, filesize($filename));
		fclose ($fr);
		for($i = 0; $i < strlen($str); $i++)
		{
			$byte_counter++;
			//echo $byte_counter;
			if($str[$i] == '\n' || $str[$i] == chr(13) || $str[$i] == chr(10))
			{
				if($byte_counter > $max)
				{
					$max = $byte_counter;
				}
				$byte_counter = 0;
			}
		}
		return $max;
	}
// #######################################################################################
	function is_date_valid($str, $format)
	{
		$date_arr = split_date($str, $format);
		return checkdate ($date_arr['month'], $date_arr['day'], $date_arr['year']);
	}
// #######################################################################################
	function split_date($str, $format)
	{
		$day;
		$month;
		$year;
		$i;
		$month_counter = 0;
		$format = strtoupper($format);
		for($i = 0; $i < strlen($format); $i++)
		{
			if($format[$i] == 'Y')
			{
				$year = $year . $str[$i];
			}
			elseif ($format[$i] == 'M')
			{
				$month = $month . $str[$i];
				$month_counter++;
			}
			elseif ($format[$i] == 'D')
			{
				$day = $day . $str[$i];
			}
		}
		if($month_counter == 3)
			$month = longmonth_to_shortmonth($month);
		elseif($month_counter > 3)
			$month = longmonth_to_shortmonth($month);
		return array('year' => $year, 'month' => $month, 'day' => $day);
	}
// #######################################################################################
	function longmonth_to_shortmonth($str)
	{
		$month = array
		(
			array('short' => 1, 'medium' => 'JAN', 'long' => 'JANUARY'),
			array('short' => 2, 'medium' => 'FEB', 'long' => 'FEBRUARY'),
			array('short' => 3, 'medium' => 'MAR', 'long' => 'MARCH'),
			array('short' => 4, 'medium' => 'APR', 'long' => 'APRIL'),
			array('short' => 5, 'medium' => 'MAY', 'long' => 'MAY'),
			array('short' => 6, 'medium' => 'JUN', 'long' => 'JUNE'),
			array('short' => 7, 'medium' => 'JUL', 'long' => 'JULY'),
			array('short' => 8, 'medium' => 'AUG', 'long' => 'AUGUST'),
			array('short' => 9, 'medium' => 'SEP', 'long' => 'SEPTEMBER'),
			array('short' => 10, 'medium' => 'OCT', 'long' => 'OCTOBER'),
			array('short' => 11, 'medium' => 'NOV', 'long' => 'NOVEMBER'),
			array('short' => 12, 'medium' => 'DEC', 'long' => 'DECEMBER')
		);
		$str = strtoupper($str);
		$length = strlen($str);
		if($length == 3)
		{
			foreach($month as $element)
			{
				if($element['medium'] == $str)
				{
					return $element['short'];
				}
			}
		}
		elseif($length > 3)
		{
			foreach($month as $element)
			{
				if($element['long'] == $str)
				{
					return $element['short'];
				}
			}
		}
		return -1;
	}
?>